#ifndef _DXGRAPHICS_QUAT_H_
#define _DXGRAPHICS_QUAT_H_

#include <OpenGL/gl.h>
#include <OpenGL/glu.h>


// Quaternion Structure
// quaternion is represented as (w,[x,y,z])
// where: w       - scalar part
//        x, y, z - vector part
typedef struct tag_GL_QUAT { 
  GLfloat w, x, y, z;
} GL_QUAT;



// define APIENTRY and CALLBACK to null string if we aren't on Win32
#if !defined(WIN32)
#define APIENTRY
#define CALLBACK
#endif


 void APIENTRY  glq_QuatToMat_EXT(GL_QUAT *, GLfloat m[4][4]);
 void APIENTRY  glq_EulerToQuat_EXT(GLfloat, GLfloat, GLfloat, GL_QUAT * );
 void APIENTRY  glq_MatToQuat_EXT(GLfloat m[4][4], GL_QUAT *);
 void APIENTRY  glq_QuatSlerp_EXT(GL_QUAT * , GL_QUAT * , GLfloat, GL_QUAT *);
 void APIENTRY  glq_QuatLerp_EXT(GL_QUAT *, GL_QUAT *, GLfloat, GL_QUAT *);
 void APIENTRY  glq_QuatNormalize_EXT(GL_QUAT *);
 void APIENTRY  glq_QuatGetValue_EXT(GL_QUAT*, GLfloat*, GLfloat*, GLfloat*, GLfloat*);
 void APIENTRY  glq_QuatSetValue_EXT(GL_QUAT *, GLfloat, GLfloat, GLfloat, GLfloat);
 void APIENTRY  glq_QuatScaleAngle_EXT(GL_QUAT *, GLfloat);
 void APIENTRY  glq_QuatInverse_EXT(GL_QUAT *);
 void APIENTRY  glq_QuatSetFromAx_EXT(GLfloat, GLfloat, GLfloat, GLfloat, GLfloat, 
										  GLfloat, GL_QUAT *);
 void APIENTRY  glq_QuatMul_EXT(GL_QUAT*, GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatAdd_EXT(GL_QUAT*, GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatSub_EXT(GL_QUAT*, GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatDiv_EXT(GL_QUAT*, GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatCopy_EXT(GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatSquare_EXT(GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatSqrt_EXT(GL_QUAT*, GL_QUAT*);
 GLfloat APIENTRY  glq_QuatDot_EXT(GL_QUAT*, GL_QUAT*);
 GLfloat APIENTRY  glq_QuatLength_EXT(GL_QUAT*);
 void APIENTRY  glq_QuatNegate_EXT(GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatExp_EXT(GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatLog_EXT(GL_QUAT*, GL_QUAT*);
 void APIENTRY  glq_QuatLnDif_EXT(GL_QUAT*, GL_QUAT*, GL_QUAT*);



#endif  // _DXGRAPHICS_QUAT_H_

